function buildSendToMarsEditURL() {
	var baseUrl = 'marsedit:';
	var url = baseUrl;
	var title = document.title;

	url = url + 'title=' + encodeURIComponent(title);
	var currentUrl = '';
	if (document.location != null)
	{
		currentUrl = document.location.href;
	}

	url = url + '&url=' + encodeURIComponent(currentUrl);
	var selectedText = getSelection();
	if (selectedText != '')
		url = url + '&text=' + encodeURIComponent(selectedText);

	return url;
}

function messageHandler(event) {
	if (event.name === "toolbarButtonClicked")
	{
		// Workaround Radar #31182842, in which residual copies of our
		// app extension may remain loaded in context of pages in Safari,
		// causing multiple responses to broadcast message about toolbar
		// button being clicked. In the case of the "extra" injections,
		// the document location is null, so we can avoid doing on anything.
		// Note this is related to the problem below where the ping fails
		// when document.location is null, but we specifically have to
		// check again at toolbarButtonClicked time because each of the
		// residual instances will receive the message.
		if (document.location != null)
		{
			urlToOpen = buildSendToMarsEditURL();
			safari.extension.dispatchMessage("openURL", { "url": urlToOpen });
		}
	}
	else if (event.name === "ping")
	{
		// Just a hack to get the toolbar icon validation to work as expected.
		// If we don't pong back, the extension knows we are not loaded in a page.

		// There is a bug in Safari where the messageHandler is apparently held on to by Safari
		// even after an extension is disabled. So an effort to "ping" an extension's scripts will
		// succeed even if its been disabled and the page reloaded. Checking for the existance of
		// document.location seems to ensure we have enough of a handle still on the document that
		// we can do something useful with it.
		var shouldValidate = (document.location != null);

		// Pass back the same validationID we were handed so they can look up the correlated validationHandler
		safari.extension.dispatchMessage("pong", { "validationID": event.message.validationID, "shouldValidate": shouldValidate });
	}
}

document.addEventListener("DOMContentLoaded", function(event) {
	// Prevent injecting the JavaScript in IFRAMES, and from acting before Safari is ready...
	if ((window.top === window) && 	(typeof safari != 'undefined') && (document.location != null))
	{
		safari.self.addEventListener("message", messageHandler, false)
	}
});

// Context menu
function handleContextMenu(event) {
	safari.extension.setContextMenuEventUserInfo(event, { "url": buildSendToMarsEditURL() });
}
document.addEventListener("contextmenu", handleContextMenu, false);
